/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2302;
import net.minecraft.class_2680;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VillagerPlantableRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(VillagerPlantableRegistry.class);
    private static final HashMap<class_1792, class_2680> PLANTABLES = new HashMap();

    private VillagerPlantableRegistry() {
    }

    public static void register(class_1935 item) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        if (!(item.method_8389() instanceof class_1747)) {
            throw new IllegalArgumentException("item is not a BlockItem");
        }
        VillagerPlantableRegistry.register(item, ((class_1747)item.method_8389()).method_7711().method_9564());
    }

    public static void register(class_1935 item, class_2680 plantState) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        Objects.requireNonNull(plantState, "Plant block state cannot be null!");
        PLANTABLES.put(item.method_8389(), plantState);
        if (!(plantState.method_26204() instanceof class_2302)) {
            LOGGER.info("Registered a block ({}) that does not extend CropBlock, this block will not be villager harvestable by default.", (Object)class_7923.field_41175.method_10221((Object)plantState.method_26204()));
        }
    }

    public static boolean contains(class_1935 item) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        return PLANTABLES.containsKey(item.method_8389());
    }

    public static class_2680 getPlantState(class_1935 item) {
        Objects.requireNonNull(item.method_8389(), "Item cannot be null!");
        return PLANTABLES.get(item.method_8389());
    }

    public static Set<class_1792> getItems() {
        return Collections.unmodifiableSet(PLANTABLES.keySet());
    }

    static {
        VillagerPlantableRegistry.register((class_1935)class_1802.field_8317);
        VillagerPlantableRegistry.register((class_1935)class_1802.field_8179);
        VillagerPlantableRegistry.register((class_1935)class_1802.field_8567);
        VillagerPlantableRegistry.register((class_1935)class_1802.field_8309);
    }
}

