/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient;

import io.netty.channel.ChannelHandler;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.impl.recipe.ingredient.CustomIngredientImpl;
import net.fabricmc.fabric.impl.recipe.ingredient.SupportedIngredientsPacketEncoder;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CustomIngredientSync
implements ModInitializer {
    public static final class_2960 PACKET_ID = new class_2960("fabric", "custom_ingredient_sync");
    public static final int PROTOCOL_VERSION_1 = 1;
    public static final ThreadLocal<Set<class_2960>> CURRENT_SUPPORTED_INGREDIENTS = new ThreadLocal();

    @Nullable
    public static class_2540 createResponsePacket(int serverProtocolVersion) {
        if (serverProtocolVersion < 1) {
            return null;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(1);
        buf.method_34062(CustomIngredientImpl.REGISTERED_SERIALIZERS.keySet(), class_2540::method_10812);
        return buf;
    }

    public static Set<class_2960> decodeResponsePacket(class_2540 buf) {
        int protocolVersion = buf.method_10816();
        switch (protocolVersion) {
            case 1: {
                Set identifiers = (Set)buf.method_34068(HashSet::new, class_2540::method_10810);
                identifiers.removeIf(id -> !CustomIngredientImpl.REGISTERED_SERIALIZERS.containsKey(id));
                return identifiers;
            }
        }
        throw new IllegalArgumentException("Unknown ingredient sync protocol version: " + protocolVersion);
    }

    public void onInitialize() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10804(1);
            sender.sendPacket(PACKET_ID, buf);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)PACKET_ID, (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                return;
            }
            Set<class_2960> supportedCustomIngredients = CustomIngredientSync.decodeResponsePacket(buf);
            ChannelHandler packetEncoder = handler.field_14158.field_11651.pipeline().get("encoder");
            if (packetEncoder != null) {
                ((SupportedIngredientsPacketEncoder)packetEncoder).fabric_setSupportedCustomIngredients(supportedCustomIngredients);
            }
        });
    }
}

