/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.tag.client.v1;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.tag.client.ClientTagsLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public final class ClientTags {
    private static final Map<class_6862<?>, Set<class_2960>> LOCAL_TAG_CACHE = new ConcurrentHashMap();

    private ClientTags() {
    }

    public static Set<class_2960> getOrCreateLocalTag(class_6862<?> tagKey) {
        Set<class_2960> ids = LOCAL_TAG_CACHE.get(tagKey);
        if (ids == null) {
            ids = ClientTagsLoader.loadTag(tagKey);
            LOCAL_TAG_CACHE.put(tagKey, ids);
        }
        return ids;
    }

    public static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, T entry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(entry);
        Optional<class_2378<T>> maybeRegistry = ClientTags.getRegistry(tagKey);
        if (maybeRegistry.isEmpty()) {
            return false;
        }
        if (!tagKey.method_41007(maybeRegistry.get().method_30517())) {
            return false;
        }
        class_2378 registry = maybeRegistry.get();
        Optional maybeKey = registry.method_29113(entry);
        if (registry.method_40266(tagKey).isPresent()) {
            return maybeKey.filter(registryKey -> registry.method_40290(registryKey).method_40220(tagKey)).isPresent();
        }
        Set<class_2960> ids = ClientTags.getOrCreateLocalTag(tagKey);
        return maybeKey.filter(registryKey -> ids.contains(registryKey.method_29177())).isPresent();
    }

    public static <T> boolean isInWithLocalFallback(class_6862<T> tagKey, class_6880<T> registryEntry) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryEntry);
        Optional<class_2378<T>> maybeRegistry = ClientTags.getRegistry(tagKey);
        if (maybeRegistry.isPresent() && maybeRegistry.get().method_40266(tagKey).isPresent()) {
            return registryEntry.method_40220(tagKey);
        }
        if (registryEntry.method_40230().isPresent()) {
            return ClientTags.isInLocal(tagKey, (class_5321)registryEntry.method_40230().get());
        }
        return false;
    }

    public static <T> boolean isInLocal(class_6862<T> tagKey, class_5321<T> registryKey) {
        Objects.requireNonNull(tagKey);
        Objects.requireNonNull(registryKey);
        if (tagKey.comp_326().method_29177().equals((Object)registryKey.method_41185())) {
            Set<class_2960> ids = ClientTags.getOrCreateLocalTag(tagKey);
            return ids.contains(registryKey.method_29177());
        }
        return false;
    }

    private static <T> Optional<? extends class_2378<T>> getRegistry(class_6862<T> tagKey) {
        Optional maybeRegistry;
        Objects.requireNonNull(tagKey);
        if (class_310.method_1551() != null && class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_30349() != null && (maybeRegistry = class_310.method_1551().field_1687.method_30349().method_33310(tagKey.comp_326())).isPresent()) {
            return maybeRegistry;
        }
        return class_7923.field_41167.method_17966(tagKey.comp_326().method_29177());
    }
}

