/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.effective.client.particle;

import ladysnake.effective.client.Effective;
import ladysnake.effective.client.EffectiveConfig;
import ladysnake.effective.client.particle.types.SplashParticleType;
import ladysnake.effective.client.render.entity.model.SplashBottomModel;
import ladysnake.effective.client.render.entity.model.SplashBottomRimModel;
import ladysnake.effective.client.render.entity.model.SplashModel;
import ladysnake.effective.client.render.entity.model.SplashRimModel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1163;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3879;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;

public class SplashParticle
extends class_703 {
    static final int MAX_FRAME = 12;
    public float widthMultiplier;
    public float heightMultiplier;
    public int wave1End;
    public int wave2Start;
    public int wave2End;
    public int waterColor = -1;
    class_3879 waveModel = new SplashModel(class_310.method_1551().method_31974().method_32072(SplashModel.MODEL_LAYER));
    class_3879 waveBottomModel = new SplashBottomModel(class_310.method_1551().method_31974().method_32072(SplashBottomModel.MODEL_LAYER));
    class_3879 waveRimModel = new SplashRimModel(class_310.method_1551().method_31974().method_32072(SplashRimModel.MODEL_LAYER));
    class_3879 waveBottomRimModel = new SplashBottomRimModel(class_310.method_1551().method_31974().method_32072(SplashBottomRimModel.MODEL_LAYER));

    protected SplashParticle(class_638 world, double x, double y, double z) {
        super(world, x, y, z);
        this.field_3844 = 0.0f;
        this.widthMultiplier = 0.0f;
        this.heightMultiplier = 0.0f;
        this.wave1End = 12;
        this.wave2Start = 7;
        this.wave2End = 24;
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        if (this.field_3866 <= this.wave1End) {
            this.drawSplash(Math.round((float)this.field_3866 / (float)this.wave1End * 12.0f), camera, tickDelta);
        }
        if (this.field_3866 >= this.wave2Start) {
            this.drawSplash(Math.round((float)(this.field_3866 - this.wave2Start) / (float)(this.wave2End - this.wave2Start) * 12.0f), camera, tickDelta, new class_1160(0.5f, 2.0f, 0.5f));
        }
    }

    private void drawSplash(int frame, class_4184 camera, float tickDelta, class_1160 multiplier) {
        if (this.waterColor == -1) {
            this.waterColor = class_1163.method_4961((class_1920)this.field_3851, (class_2338)new class_2338(this.field_3874, this.field_3854, this.field_3871));
        }
        float r = (float)(this.waterColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.waterColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.waterColor & 0xFF) / 255.0f;
        class_2960 texture = new class_2960("effective", "textures/entity/splash/splash_" + class_3532.method_15340((int)frame, (int)0, (int)12) + ".png");
        class_1921 layer = class_1921.method_23580((class_2960)texture);
        class_2960 rimTexture = new class_2960("effective", "textures/entity/splash/splash_rim_" + class_3532.method_15340((int)frame, (int)0, (int)12) + ".png");
        class_1921 rimLayer = class_1921.method_23580((class_2960)rimTexture);
        class_4587 modelMatrix = this.getMatrixStackFromCamera(camera, tickDelta);
        modelMatrix.method_22905(this.widthMultiplier * multiplier.method_4943(), -this.heightMultiplier * multiplier.method_4945(), this.widthMultiplier * multiplier.method_4947());
        modelMatrix.method_22904(0.0, -1.0, 0.0);
        class_4587 modelBottomMatrix = this.getMatrixStackFromCamera(camera, tickDelta);
        modelBottomMatrix.method_22905(this.widthMultiplier * multiplier.method_4943(), this.heightMultiplier * multiplier.method_4945(), this.widthMultiplier * multiplier.method_4947());
        modelBottomMatrix.method_22904(0.0, 0.001, 0.0);
        float splashRimScaleOffset = 1.0E-4f;
        class_4587 modelRimMatrix = this.getMatrixStackFromCamera(camera, tickDelta);
        modelRimMatrix.method_22905(this.widthMultiplier * multiplier.method_4943() + splashRimScaleOffset, -this.heightMultiplier * multiplier.method_4945() - splashRimScaleOffset, this.widthMultiplier * multiplier.method_4947() + splashRimScaleOffset);
        modelRimMatrix.method_22904(0.0, -1.001, 0.0);
        class_4587 modelRimBottomMatrix = this.getMatrixStackFromCamera(camera, tickDelta);
        modelRimBottomMatrix.method_22905(this.widthMultiplier * multiplier.method_4943() + splashRimScaleOffset, this.heightMultiplier * multiplier.method_4945() + splashRimScaleOffset, this.widthMultiplier * multiplier.method_4947() + splashRimScaleOffset);
        modelRimBottomMatrix.method_22904(0.0, 0.002, 0.0);
        int light = this.method_3068(tickDelta);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        class_4588 modelConsumer = immediate.getBuffer(layer);
        this.waveModel.method_2828(modelMatrix, modelConsumer, light, class_4608.field_21444, r, g, b, 0.9f);
        this.waveBottomModel.method_2828(modelBottomMatrix, modelConsumer, light, class_4608.field_21444, r, g, b, 0.9f);
        class_4588 rimModelConsumer = immediate.getBuffer(rimLayer);
        this.waveRimModel.method_2828(modelRimMatrix, rimModelConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, EffectiveConfig.splashRimAlpha);
        this.waveBottomRimModel.method_2828(modelRimBottomMatrix, rimModelConsumer, light, class_4608.field_21444, 1.0f, 1.0f, 1.0f, EffectiveConfig.splashRimAlpha);
        immediate.method_22993();
    }

    private void drawSplash(int frame, class_4184 camera, float tickDelta) {
        this.drawSplash(frame, camera, tickDelta, new class_1160(1.0f, 1.0f, 1.0f));
    }

    private class_4587 getMatrixStackFromCamera(class_4184 camera, float tickDelta) {
        class_243 cameraPos = camera.method_19326();
        float x = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3858, (double)this.field_3874) - cameraPos.method_10216());
        float y = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3838, (double)this.field_3854) - cameraPos.method_10214());
        float z = (float)(class_3532.method_16436((double)tickDelta, (double)this.field_3856, (double)this.field_3871) - cameraPos.method_10215());
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904((double)x, (double)y, (double)z);
        return matrixStack;
    }

    public void method_3070() {
        block5: {
            block4: {
                if (this.widthMultiplier == 0.0f) {
                    this.method_3085();
                }
                this.field_3858 = this.field_3874;
                this.field_3838 = this.field_3854;
                this.field_3856 = this.field_3871;
                this.widthMultiplier *= 1.03f;
                if (this.field_3866++ >= this.wave2End) {
                    this.method_3085();
                }
                if (this.field_3866 != 1) break block4;
                int i = 0;
                while ((float)i < this.widthMultiplier * 10.0f) {
                    this.field_3851.method_8406((class_2394)Effective.DROPLET, this.field_3874 + this.field_3840.method_43059() * (double)this.widthMultiplier / 10.0, this.field_3854, this.field_3871 + this.field_3840.method_43059() * (double)this.widthMultiplier / 10.0, this.field_3840.method_43059() / 10.0 * (double)this.widthMultiplier / 2.5, (double)(this.field_3840.method_43057() / 10.0f + this.heightMultiplier / 2.8f), this.field_3840.method_43059() / 10.0 * (double)this.widthMultiplier / 2.5);
                    ++i;
                }
                break block5;
            }
            if (this.field_3866 != this.wave2Start) break block5;
            int i = 0;
            while ((float)i < this.widthMultiplier * 5.0f) {
                this.field_3851.method_8406((class_2394)Effective.DROPLET, this.field_3874 + this.field_3840.method_43059() * (double)this.widthMultiplier / 10.0 * 0.5, this.field_3854, this.field_3871 + this.field_3840.method_43059() * (double)this.widthMultiplier / 10.0 * 0.5, this.field_3840.method_43059() / 10.0 * (double)this.widthMultiplier / 5.0, (double)(this.field_3840.method_43057() / 10.0f + this.heightMultiplier / 2.2f), this.field_3840.method_43059() / 10.0 * (double)this.widthMultiplier / 5.0);
                ++i;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DefaultFactory
    implements class_707<class_2400> {
        public DefaultFactory(class_4002 spriteProvider) {
        }

        @Nullable
        public class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            SplashParticle instance = new SplashParticle(world, x, y, z);
            if (parameters instanceof SplashParticleType) {
                SplashParticleType splashParameters = (SplashParticleType)parameters;
                if (splashParameters.initialData != null) {
                    float width;
                    instance.widthMultiplier = width = (float)splashParameters.initialData.width * 2.0f;
                    instance.heightMultiplier = (float)splashParameters.initialData.velocityY * width;
                    instance.wave1End = 10 + Math.round(width * 1.2f);
                    instance.wave2Start = 6 + Math.round(width * 0.7f);
                    instance.wave2End = 20 + Math.round(width * 2.4f);
                }
            }
            return instance;
        }
    }
}

