/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.buffer;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import java.util.Collections;
import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.buffer.ShaderStorageBuffer;
import net.coderbot.iris.gl.sampler.SamplerLimits;

public class ShaderStorageBufferHolder {
    private ShaderStorageBuffer[] buffers;
    private boolean destroyed = false;

    public ShaderStorageBufferHolder(Int2IntArrayMap int2IntArrayMap) {
        this.buffers = new ShaderStorageBuffer[(Integer)Collections.max(int2IntArrayMap.keySet()) + 1];
        int2IntArrayMap.forEach((n, n2) -> {
            if ((long)n2.intValue() > IrisRenderSystem.getVRAM()) {
                throw new OutOfVideoMemoryError("We only have " + ShaderStorageBufferHolder.toMib(IrisRenderSystem.getVRAM()) + "MiB of RAM to work with, but the pack is requesting " + n2 + "! Can't continue.");
            }
            int n3 = GlStateManager._glGenBuffers();
            GlStateManager._glBindBuffer((int)37074, (int)n3);
            IrisRenderSystem.bufferStorage(37074, n2.intValue(), 0);
            IrisRenderSystem.clearBufferSubData(37074, 33321, 0L, n2.intValue(), 6403, 5120, new int[]{0});
            if (n > SamplerLimits.get().getMaxShaderStorageUnits()) {
                throw new IllegalStateException("We don't have enough SSBO units??? (index: " + n + ", max: " + SamplerLimits.get().getMaxShaderStorageUnits());
            }
            IrisRenderSystem.bindBufferBase(37074, n, n3);
            this.buffers[n.intValue()] = new ShaderStorageBuffer(n3, (int)n, n2.intValue());
        });
        GlStateManager._glBindBuffer((int)37074, (int)0);
    }

    private static long toMib(long l) {
        return l / 1024L / 1024L;
    }

    public void setupBuffers() {
        if (this.destroyed) {
            throw new IllegalStateException("Tried to use destroyed buffer objects");
        }
        for (ShaderStorageBuffer shaderStorageBuffer : this.buffers) {
            shaderStorageBuffer.bind();
        }
    }

    public void destroyBuffers() {
        for (ShaderStorageBuffer shaderStorageBuffer : this.buffers) {
            shaderStorageBuffer.destroy();
        }
        this.buffers = null;
        this.destroyed = true;
    }

    private static class OutOfVideoMemoryError
    extends RuntimeException {
        public OutOfVideoMemoryError(String string) {
            super(string);
        }
    }
}

