/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.class_1267;
import net.minecraft.class_128;
import net.minecraft.class_1419;
import net.minecraft.class_148;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1863;
import net.minecraft.class_1923;
import net.minecraft.class_1928;
import net.minecraft.class_1932;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1940;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_2632;
import net.minecraft.class_27;
import net.minecraft.class_2761;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_29;
import net.minecraft.class_2902;
import net.minecraft.class_2910;
import net.minecraft.class_2926;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2989;
import net.minecraft.class_2991;
import net.minecraft.class_2995;
import net.minecraft.class_3004;
import net.minecraft.class_32;
import net.minecraft.class_3201;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3230;
import net.minecraft.class_3242;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3327;
import net.minecraft.class_3337;
import net.minecraft.class_3485;
import net.minecraft.class_3515;
import net.minecraft.class_3517;
import net.minecraft.class_3532;
import net.minecraft.class_3534;
import net.minecraft.class_3688;
import net.minecraft.class_3695;
import net.minecraft.class_3696;
import net.minecraft.class_3738;
import net.minecraft.class_3769;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_3950;
import net.minecraft.class_3990;
import net.minecraft.class_4093;
import net.minecraft.class_4274;
import net.minecraft.class_4521;
import net.minecraft.class_4543;
import net.minecraft.class_4565;
import net.minecraft.class_4567;
import net.minecraft.class_4758;
import net.minecraft.class_5217;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5304;
import net.minecraft.class_5321;
import net.minecraft.class_5322;
import net.minecraft.class_5350;
import net.minecraft.class_5359;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_5513;
import net.minecraft.class_5525;
import net.minecraft.class_5640;
import net.minecraft.class_5819;
import net.minecraft.class_5961;
import net.minecraft.class_5962;
import net.minecraft.class_5963;
import net.minecraft.class_5971;
import net.minecraft.class_60;
import net.minecraft.class_6396;
import net.minecraft.class_6402;
import net.minecraft.class_6498;
import net.minecraft.class_6611;
import net.minecraft.class_6613;
import net.minecraft.class_6683;
import net.minecraft.class_6804;
import net.minecraft.class_6860;
import net.minecraft.class_6861;
import net.minecraft.class_6904;
import net.minecraft.class_7225;
import net.minecraft.class_7492;
import net.minecraft.class_7497;
import net.minecraft.class_7500;
import net.minecraft.class_7659;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7712;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import net.minecraft.obfuscate.DontObfuscate;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends class_4093<class_3738>
implements class_2165,
AutoCloseable {
    private static final Logger field_4546 = LogUtils.getLogger();
    public static final String field_34982 = "vanilla";
    private static final float field_33212 = 0.8f;
    private static final int field_33213 = 100;
    public static final int field_33206 = 50;
    private static final int field_33215 = 2000;
    private static final int field_33216 = 15000;
    private static final long field_33217 = 5000000000L;
    private static final int field_33218 = 12;
    public static final int field_33210 = 11;
    private static final int field_33219 = 441;
    private static final int field_33220 = 6000;
    private static final int field_33221 = 3;
    public static final int field_33211 = 29999984;
    public static final class_1940 field_17704 = new class_1940("Demo World", class_1934.field_9215, false, class_1267.field_5802, false, new class_1928(), class_7712.field_40260);
    private static final long field_33205 = 50L;
    public static final GameProfile field_35641 = new GameProfile(class_156.field_25140, "Anonymous Player");
    protected final class_32.class_5143 field_23784;
    protected final class_29 field_24371;
    private final List<Runnable> field_4568 = Lists.newArrayList();
    private class_5962 field_22250 = class_5963.field_29594;
    private class_3695 field_16258 = this.field_22250.method_34774();
    private Consumer<class_3696> field_33975 = $$0 -> this.method_37322();
    private Consumer<Path> field_33976 = $$0 -> {};
    private boolean field_33977;
    @Nullable
    private class_6414 field_33978;
    private boolean field_33979;
    private final class_3242 field_4563;
    private final class_3950 field_17439;
    @Nullable
    private class_2926 field_4593;
    @Nullable
    private class_2926.class_8145 field_42958;
    private final class_5819 field_4602 = class_5819.method_43047();
    private final DataFixer field_4587;
    private String field_4585;
    private int field_4555 = -1;
    private final class_7780<class_7659> field_25132;
    private final Map<class_5321<class_1937>, class_3218> field_4589 = Maps.newLinkedHashMap();
    private class_3324 field_4550;
    private volatile boolean field_4544 = true;
    private boolean field_4561;
    private int field_4572;
    protected final Proxy field_4599;
    private boolean field_4543;
    private boolean field_4560;
    private boolean field_4604;
    private boolean field_4554;
    @Nullable
    private String field_4564;
    private int field_4596;
    public final long[] field_4573 = new long[100];
    @Nullable
    private KeyPair field_4552;
    @Nullable
    private GameProfile field_39214;
    private boolean field_4549;
    private volatile boolean field_4547;
    private long field_4557;
    protected final class_7497 field_39440;
    private long field_4551;
    private final Thread field_16257;
    private long field_4571 = class_156.method_658();
    private long field_19248;
    private boolean field_19249;
    private final class_3283 field_4595;
    private final class_2995 field_4558 = new class_2995(this);
    @Nullable
    private class_4565 field_20850;
    private final class_3004 field_4548 = new class_3004();
    private final class_2991 field_4591;
    private final class_3517 field_16205 = new class_3517();
    private boolean field_4570;
    private float field_4592;
    private final Executor field_17200;
    @Nullable
    private String field_17601;
    private class_6897 field_25318;
    private final class_3485 field_24370;
    protected final class_5219 field_24372;
    private volatile boolean field_35437;

    public static <S extends MinecraftServer> S method_29740(Function<Thread, S> $$02) {
        AtomicReference<MinecraftServer> $$12 = new AtomicReference<MinecraftServer>();
        Thread $$2 = new Thread(() -> ((MinecraftServer)$$12.get()).method_29741(), "Server thread");
        $$2.setUncaughtExceptionHandler(($$0, $$1) -> field_4546.error("Uncaught exception in server thread", $$1));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            $$2.setPriority(8);
        }
        MinecraftServer $$3 = (MinecraftServer)$$02.apply($$2);
        $$12.set($$3);
        $$2.start();
        return (S)$$3;
    }

    public MinecraftServer(Thread $$02, class_32.class_5143 $$1, class_3283 $$2, class_6904 $$3, Proxy $$4, DataFixer $$5, class_7497 $$6, class_3950 $$7) {
        super("Server");
        this.field_25132 = $$3.comp_358();
        this.field_24372 = $$3.comp_359();
        if (!this.field_25132.method_45926().method_30530(class_7924.field_41224).method_35842(class_5363.field_25412)) {
            throw new IllegalStateException("Missing Overworld dimension data");
        }
        this.field_4599 = $$4;
        this.field_4595 = $$2;
        this.field_25318 = new class_6897($$3.comp_356(), $$3.comp_357());
        this.field_39440 = $$6;
        if ($$6.comp_840() != null) {
            $$6.comp_840().method_37157(this);
        }
        this.field_4563 = new class_3242(this);
        this.field_17439 = $$7;
        this.field_23784 = $$1;
        this.field_24371 = $$1.method_27427();
        this.field_4587 = $$5;
        this.field_4591 = new class_2991(this, this.field_25318.comp_353.method_29465());
        class_7225<class_2248> $$8 = this.field_25132.method_45926().method_30530(class_7924.field_41254).method_46771().method_45919(this.field_24372.method_45560());
        this.field_24370 = new class_3485($$3.comp_356(), $$1, $$5, $$8);
        this.field_16257 = $$02;
        this.field_17200 = class_156.method_18349();
    }

    private void method_17976(class_26 $$0) {
        $$0.method_17924(this.method_3845()::method_32704, this.method_3845()::method_32705, "scoreboard");
    }

    protected abstract boolean method_3823() throws IOException;

    protected void method_3735() {
        if (!class_6611.field_34923.method_37984()) {
            // empty if block
        }
        boolean $$0 = false;
        class_6613 $$1 = class_6611.field_34923.method_38659();
        this.field_24372.method_24285(this.getServerModName(), this.method_24307().method_39029());
        class_3949 $$2 = this.field_17439.create(11);
        this.method_3786($$2);
        this.method_27731();
        this.method_3774($$2);
        if ($$1 != null) {
            $$1.finish();
        }
        if ($$0) {
            try {
                class_6611.field_34923.method_37980();
            }
            catch (Throwable $$3) {
                field_4546.warn("Failed to stop JFR profiling", $$3);
            }
        }
    }

    protected void method_27731() {
    }

    protected void method_3786(class_3949 $$0) {
        class_5268 $$1 = this.field_24372.method_27859();
        boolean $$2 = this.field_24372.method_45556();
        class_2378<class_5363> $$3 = this.field_25132.method_45926().method_30530(class_7924.field_41224);
        class_5285 $$4 = this.field_24372.method_28057();
        long $$5 = $$4.method_28028();
        long $$6 = class_4543.method_27984($$5);
        ImmutableList $$7 = ImmutableList.of((Object)new class_2910(), (Object)new class_3769(), (Object)new class_4274(), (Object)new class_1419(), (Object)new class_3990($$1));
        class_5363 $$8 = $$3.method_29107(class_5363.field_25412);
        class_3218 $$9 = new class_3218(this, this.field_17200, this.field_23784, $$1, class_1937.field_25179, $$8, $$0, $$2, $$6, (List<class_5304>)$$7, true);
        this.field_4589.put(class_1937.field_25179, $$9);
        class_26 $$10 = $$9.method_17983();
        this.method_17976($$10);
        this.field_20850 = new class_4565($$10);
        class_2784 $$11 = $$9.method_8621();
        if (!$$1.method_222()) {
            try {
                MinecraftServer.method_27901($$9, $$1, $$4.method_28030(), $$2);
                $$1.method_223(true);
                if ($$2) {
                    this.method_17977(this.field_24372);
                }
            }
            catch (Throwable $$12) {
                class_128 $$13 = class_128.method_560($$12, "Exception initializing level");
                try {
                    $$9.method_8538($$13);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new class_148($$13);
            }
            $$1.method_223(true);
        }
        this.method_3760().method_14591($$9);
        if (this.field_24372.method_228() != null) {
            this.method_3837().method_12972(this.field_24372.method_228());
        }
        for (Map.Entry<class_5321<class_5363>, class_5363> $$14 : $$3.method_29722()) {
            class_5321<class_5363> $$15 = $$14.getKey();
            if ($$15 == class_5363.field_25412) continue;
            class_5321<class_1937> $$16 = class_5321.method_29179(class_7924.field_41223, $$15.method_29177());
            class_27 $$17 = new class_27(this.field_24372, $$1);
            class_3218 $$18 = new class_3218(this, this.field_17200, this.field_23784, $$17, $$16, $$14.getValue(), $$0, $$2, $$6, (List<class_5304>)ImmutableList.of(), false);
            $$11.method_11983(new class_2780.class_3976($$18.method_8621()));
            this.field_4589.put($$16, $$18);
        }
        $$11.method_17905($$1.method_27422());
    }

    private static void method_27901(class_3218 $$02, class_5268 $$1, boolean $$2, boolean $$32) {
        if ($$32) {
            $$1.method_187(class_2338.field_10980.method_10086(80), 0.0f);
            return;
        }
        class_3215 $$4 = $$02.method_14178();
        class_1923 $$5 = new class_1923($$4.method_41248().method_42371().method_39165());
        int $$6 = $$4.method_12129().method_12100($$02);
        if ($$6 < $$02.method_31607()) {
            class_2338 $$7 = $$5.method_8323();
            $$6 = $$02.method_8624(class_2902.class_2903.field_13202, $$7.method_10263() + 8, $$7.method_10260() + 8);
        }
        $$1.method_187($$5.method_8323().method_10069(8, $$6, 8), 0.0f);
        int $$8 = 0;
        int $$9 = 0;
        int $$10 = 0;
        int $$11 = -1;
        int $$12 = 5;
        for (int $$13 = 0; $$13 < class_3532.method_34954(11); ++$$13) {
            class_2338 $$14;
            if ($$8 >= -5 && $$8 <= 5 && $$9 >= -5 && $$9 <= 5 && ($$14 = class_5322.method_29196($$02, new class_1923($$5.field_9181 + $$8, $$5.field_9180 + $$9))) != null) {
                $$1.method_187($$14, 0.0f);
                break;
            }
            if ($$8 == $$9 || $$8 < 0 && $$8 == -$$9 || $$8 > 0 && $$8 == 1 - $$9) {
                int $$15 = $$10;
                $$10 = -$$11;
                $$11 = $$15;
            }
            $$8 += $$10;
            $$9 += $$11;
        }
        if ($$2) {
            $$02.method_30349().method_33310(class_7924.field_41239).flatMap($$0 -> $$0.method_40264(class_6804.field_35811)).ifPresent($$3 -> ((class_2975)$$3.comp_349()).method_12862($$02, $$4.method_12129(), $$0.field_9229, new class_2338($$1.method_215(), $$1.method_144(), $$1.method_166())));
        }
    }

    private void method_17977(class_5219 $$0) {
        $$0.method_208(class_1267.field_5801);
        $$0.method_186(true);
        class_5268 $$1 = $$0.method_27859();
        $$1.method_157(false);
        $$1.method_147(false);
        $$1.method_167(1000000000);
        $$1.method_29035(6000L);
        $$1.method_193(class_1934.field_9219);
    }

    private void method_3774(class_3949 $$0) {
        class_3218 $$1 = this.method_30002();
        field_4546.info("Preparing start region for dimension {}", (Object)$$1.method_27983().method_29177());
        class_2338 $$2 = $$1.method_43126();
        $$0.method_17669(new class_1923($$2));
        class_3215 $$3 = $$1.method_14178();
        $$3.method_17293().method_17304(500);
        this.field_4571 = class_156.method_658();
        $$3.method_17297(class_3230.field_14030, new class_1923($$2), 11, class_3902.field_17274);
        while ($$3.method_17301() != 441) {
            this.field_4571 = class_156.method_658() + 10L;
            this.method_16208();
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        for (class_3218 $$4 : this.field_4589.values()) {
            class_1932 $$5 = $$4.method_17983().method_20786(class_1932::method_32350, "chunks");
            if ($$5 == null) continue;
            LongIterator $$6 = $$5.method_8375().iterator();
            while ($$6.hasNext()) {
                long $$7 = $$6.nextLong();
                class_1923 $$8 = new class_1923($$7);
                $$4.method_14178().method_12124($$8, true);
            }
        }
        this.field_4571 = class_156.method_658() + 10L;
        this.method_16208();
        $$0.method_17671();
        $$3.method_17293().method_17304(5);
        this.method_27729();
    }

    public class_1934 method_3790() {
        return this.field_24372.method_210();
    }

    public boolean method_3754() {
        return this.field_24372.method_152();
    }

    public abstract int method_3798();

    public abstract int method_21714();

    public abstract boolean method_3732();

    public boolean method_3723(boolean $$0, boolean $$1, boolean $$2) {
        boolean $$3 = false;
        for (class_3218 $$4 : this.method_3738()) {
            if (!$$0) {
                field_4546.info("Saving chunks for level '{}'/{}", (Object)$$4, (Object)$$4.method_27983().method_29177());
            }
            $$4.method_14176(null, $$1, $$4.field_13957 && !$$2);
            $$3 = true;
        }
        class_3218 $$5 = this.method_30002();
        class_5268 $$6 = this.field_24372.method_27859();
        $$6.method_27415($$5.method_8621().method_27355());
        this.field_24372.method_221(this.method_3837().method_12974());
        this.field_23784.method_27426(this.method_30611(), this.field_24372, this.method_3760().method_14567());
        if ($$1) {
            for (class_3218 $$7 : this.method_3738()) {
                field_4546.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)$$7.method_14178().field_17254.method_37476());
            }
            field_4546.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return $$3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean method_39218(boolean $$0, boolean $$1, boolean $$2) {
        try {
            this.field_35437 = true;
            this.method_3760().method_14617();
            boolean bl = this.method_3723($$0, $$1, $$2);
            return bl;
        }
        finally {
            this.field_35437 = false;
        }
    }

    @Override
    public void close() {
        this.method_3782();
    }

    public void method_3782() {
        if (this.field_22250.method_34773()) {
            this.method_42062();
        }
        field_4546.info("Stopping server");
        if (this.method_3787() != null) {
            this.method_3787().method_14356();
        }
        this.field_35437 = true;
        if (this.field_4550 != null) {
            field_4546.info("Saving players");
            this.field_4550.method_14617();
            this.field_4550.method_14597();
        }
        field_4546.info("Saving worlds");
        for (class_3218 $$02 : this.method_3738()) {
            if ($$02 == null) continue;
            $$02.field_13957 = false;
        }
        while (this.field_4589.values().stream().anyMatch($$0 -> $$0.method_14178().field_17254.method_39992())) {
            this.field_4571 = class_156.method_658() + 1L;
            for (class_3218 $$1 : this.method_3738()) {
                $$1.method_14178().method_39997();
                $$1.method_14178().method_12127(() -> true, false);
            }
            this.method_16208();
        }
        this.method_3723(false, true, false);
        for (class_3218 $$2 : this.method_3738()) {
            if ($$2 == null) continue;
            try {
                $$2.close();
            }
            catch (IOException $$3) {
                field_4546.error("Exception closing the level", (Throwable)$$3);
            }
        }
        this.field_35437 = false;
        this.field_25318.close();
        try {
            this.field_23784.close();
        }
        catch (IOException $$4) {
            field_4546.error("Failed to unlock level {}", (Object)this.field_23784.method_27005(), (Object)$$4);
        }
    }

    public String method_3819() {
        return this.field_4585;
    }

    public void method_3842(String $$0) {
        this.field_4585 = $$0;
    }

    public boolean method_3806() {
        return this.field_4544;
    }

    public void method_3747(boolean $$0) {
        this.field_4544 = false;
        if ($$0) {
            try {
                this.field_16257.join();
            }
            catch (InterruptedException $$1) {
                field_4546.error("Error while shutting down", (Throwable)$$1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void method_29741() {
        block25: {
            try {
                if (this.method_3823()) {
                    this.field_4571 = class_156.method_658();
                    this.field_42958 = this.method_49384().orElse(null);
                    this.field_4593 = this.method_49385();
                    while (this.field_4544) {
                        long $$0 = class_156.method_658() - this.field_4571;
                        if ($$0 > 2000L && this.field_4571 - this.field_4557 >= 15000L) {
                            long $$1 = $$0 / 50L;
                            field_4546.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)$$0, (Object)$$1);
                            this.field_4571 += $$1 * 50L;
                            this.field_4557 = this.field_4571;
                        }
                        if (this.field_33979) {
                            this.field_33979 = false;
                            this.field_33978 = new class_6414(class_156.method_648(), this.field_4572);
                        }
                        this.field_4571 += 50L;
                        this.method_24487();
                        this.field_16258.method_15396("tick");
                        this.method_3748(this::method_3866);
                        this.field_16258.method_15405("nextTickWait");
                        this.field_19249 = true;
                        this.field_19248 = Math.max(class_156.method_658() + 50L, this.field_4571);
                        this.method_16208();
                        this.field_16258.method_15407();
                        this.method_24490();
                        this.field_4547 = true;
                        class_6611.field_34923.method_38654(this.field_4592);
                    }
                    break block25;
                }
                throw new IllegalStateException("Failed to initialize server");
            }
            catch (Throwable $$3) {
                field_4546.error("Encountered an unexpected exception", $$3);
                class_128 $$4 = MinecraftServer.method_40376($$3);
                this.method_37324($$4.method_567());
                File $$5 = new File(new File(this.method_3831(), "crash-reports"), "crash-" + class_156.method_44893() + "-server.txt");
                if ($$4.method_569($$5)) {
                    field_4546.error("This crash report has been saved to: {}", (Object)$$5.getAbsolutePath());
                } else {
                    field_4546.error("We were unable to save this crash report to disk.");
                }
                this.method_3744($$4);
            }
            finally {
                try {
                    this.field_4561 = true;
                    this.method_3782();
                }
                catch (Throwable $$2) {
                    field_4546.error("Exception stopping the server", $$2);
                }
                finally {
                    if (this.field_39440.comp_840() != null) {
                        this.field_39440.comp_840().method_39753();
                    }
                    this.method_3821();
                }
            }
        }
    }

    private static class_128 method_40376(Throwable $$0) {
        class_128 $$5;
        class_148 $$1 = null;
        for (Throwable $$2 = $$0; $$2 != null; $$2 = $$2.getCause()) {
            class_148 $$3;
            if (!($$2 instanceof class_148)) continue;
            $$1 = $$3 = (class_148)$$2;
        }
        if ($$1 != null) {
            class_128 $$4 = $$1.method_631();
            if ($$1 != $$0) {
                $$4.method_562("Wrapped in").method_585("Wrapping exception", $$0);
            }
        } else {
            $$5 = new class_128("Exception in server tick loop", $$0);
        }
        return $$5;
    }

    private boolean method_3866() {
        return this.method_18860() || class_156.method_658() < (this.field_19249 ? this.field_19248 : this.field_4571);
    }

    protected void method_16208() {
        this.method_5383();
        this.method_18857(() -> !this.method_3866());
    }

    protected class_3738 method_16209(Runnable $$0) {
        return new class_3738(this.field_4572, $$0);
    }

    protected boolean method_19464(class_3738 $$0) {
        return $$0.method_16338() + 3 < this.field_4572 || this.method_3866();
    }

    @Override
    public boolean method_16075() {
        boolean $$0;
        this.field_19249 = $$0 = this.method_20415();
        return $$0;
    }

    private boolean method_20415() {
        if (super.method_16075()) {
            return true;
        }
        if (this.method_3866()) {
            for (class_3218 $$0 : this.method_3738()) {
                if (!$$0.method_14178().method_19492()) continue;
                return true;
            }
        }
        return false;
    }

    protected void method_24306(class_3738 $$0) {
        this.method_16044().method_39278("runTask");
        super.method_18859($$0);
    }

    private Optional<class_2926.class_8145> method_49384() {
        Optional<Path> $$02 = Optional.of(this.method_3758("server-icon.png").toPath()).filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])).or(() -> this.field_23784.method_27014().filter($$0 -> Files.isRegularFile($$0, new LinkOption[0])));
        return $$02.flatMap($$0 -> {
            try {
                BufferedImage $$1 = ImageIO.read($$0.toFile());
                Preconditions.checkState(($$1.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState(($$1.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream $$2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)$$1, "PNG", $$2);
                return Optional.of(new class_2926.class_8145($$2.toByteArray()));
            }
            catch (Exception $$3) {
                field_4546.error("Couldn't load server icon", (Throwable)$$3);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> method_3725() {
        return this.field_23784.method_27014();
    }

    public File method_3831() {
        return new File(".");
    }

    public void method_3744(class_128 $$0) {
    }

    public void method_3821() {
    }

    public void method_3748(BooleanSupplier $$0) {
        long $$1 = class_156.method_648();
        ++this.field_4572;
        this.method_3813($$0);
        if ($$1 - this.field_4551 >= 5000000000L) {
            this.field_4551 = $$1;
            this.field_4593 = this.method_49385();
        }
        if (this.field_4572 % 6000 == 0) {
            field_4546.debug("Autosave started");
            this.field_16258.method_15396("save");
            this.method_39218(true, false, false);
            this.field_16258.method_15407();
            field_4546.debug("Autosave finished");
        }
        this.field_16258.method_15396("tallying");
        long l = class_156.method_648() - $$1;
        this.field_4573[this.field_4572 % 100] = l;
        long $$2 = l;
        this.field_4592 = this.field_4592 * 0.8f + (float)$$2 / 1000000.0f * 0.19999999f;
        long $$3 = class_156.method_648();
        this.field_16205.method_15247($$3 - $$1);
        this.field_16258.method_15407();
    }

    private class_2926 method_49385() {
        class_2926.class_2927 $$0 = this.method_49386();
        return new class_2926(class_2561.method_30163(this.field_4564), Optional.of($$0), Optional.of(class_2926.class_2930.method_49097()), Optional.ofNullable(this.field_42958), this.method_43500());
    }

    private class_2926.class_2927 method_49386() {
        List<class_3222> $$0 = this.field_4550.method_14571();
        int $$1 = this.method_3802();
        if (this.method_39424()) {
            return new class_2926.class_2927($$1, $$0.size(), List.of());
        }
        int $$2 = Math.min($$0.size(), 12);
        ObjectArrayList $$3 = new ObjectArrayList($$2);
        int $$4 = class_3532.method_15395(this.field_4602, 0, $$0.size() - $$2);
        for (int $$5 = 0; $$5 < $$2; ++$$5) {
            class_3222 $$6 = $$0.get($$4 + $$5);
            $$3.add((Object)($$6.method_39426() ? $$6.method_7334() : field_35641));
        }
        class_156.method_43028($$3, this.field_4602);
        return new class_2926.class_2927($$1, $$0.size(), (List<GameProfile>)$$3);
    }

    public void method_3813(BooleanSupplier $$0) {
        this.field_16258.method_15396("commandFunctions");
        this.method_3740().method_18699();
        this.field_16258.method_15405("levels");
        for (class_3218 $$1 : this.method_3738()) {
            this.field_16258.method_15400(() -> $$1 + " " + $$1.method_27983().method_29177());
            if (this.field_4572 % 20 == 0) {
                this.field_16258.method_15396("timeSync");
                this.method_49750($$1);
                this.field_16258.method_15407();
            }
            this.field_16258.method_15396("tick");
            try {
                $$1.method_18765($$0);
            }
            catch (Throwable $$2) {
                class_128 $$3 = class_128.method_560($$2, "Exception ticking world");
                $$1.method_8538($$3);
                throw new class_148($$3);
            }
            this.field_16258.method_15407();
            this.field_16258.method_15407();
        }
        this.field_16258.method_15405("connection");
        this.method_3787().method_14357();
        this.field_16258.method_15405("players");
        this.field_4550.method_14601();
        if (class_155.field_1125) {
            class_4521.field_20574.method_22228();
        }
        this.field_16258.method_15405("server gui refresh");
        for (int $$4 = 0; $$4 < this.field_4568.size(); ++$$4) {
            this.field_4568.get($$4).run();
        }
        this.field_16258.method_15407();
    }

    private void method_49750(class_3218 $$0) {
        this.field_4550.method_14589(new class_2761($$0.method_8510(), $$0.method_8532(), $$0.method_8450().method_8355(class_1928.field_19396)), $$0.method_27983());
    }

    public void method_49749() {
        this.field_16258.method_15396("timeSync");
        for (class_3218 $$0 : this.method_3738()) {
            this.method_49750($$0);
        }
        this.field_16258.method_15407();
    }

    public boolean method_3839() {
        return true;
    }

    public void method_3742(Runnable $$0) {
        this.field_4568.add($$0);
    }

    protected void method_17819(String $$0) {
        this.field_17601 = $$0;
    }

    public boolean method_16043() {
        return !this.field_16257.isAlive();
    }

    public File method_3758(String $$0) {
        return new File(this.method_3831(), $$0);
    }

    public final class_3218 method_30002() {
        return this.field_4589.get(class_1937.field_25179);
    }

    @Nullable
    public class_3218 method_3847(class_5321<class_1937> $$0) {
        return this.field_4589.get($$0);
    }

    public Set<class_5321<class_1937>> method_29435() {
        return this.field_4589.keySet();
    }

    public Iterable<class_3218> method_3738() {
        return this.field_4589.values();
    }

    public String method_3827() {
        return class_155.method_16673().method_48019();
    }

    public int method_3788() {
        return this.field_4550.method_14574();
    }

    public int method_3802() {
        return this.field_4550.method_14592();
    }

    public String[] method_3858() {
        return this.field_4550.method_14580();
    }

    @DontObfuscate
    public String getServerModName() {
        return field_34982;
    }

    public class_6396 method_37324(class_6396 $$0) {
        $$0.method_37123("Server Running", () -> Boolean.toString(this.field_4544));
        if (this.field_4550 != null) {
            $$0.method_37123("Player Count", () -> this.field_4550.method_14574() + " / " + this.field_4550.method_14592() + "; " + this.field_4550.method_14571());
        }
        $$0.method_37123("Data Packs", () -> this.field_4595.method_14444().stream().map($$0 -> $$0.method_14463() + ($$0.method_14460().method_14437() ? "" : " (incompatible)")).collect(Collectors.joining(", ")));
        $$0.method_37123("Enabled Feature Flags", () -> class_7701.field_40180.method_45392(this.field_24372.method_45560()).stream().map(class_2960::toString).collect(Collectors.joining(", ")));
        $$0.method_37123("World Generation", () -> this.field_24372.method_29588().toString());
        if (this.field_17601 != null) {
            $$0.method_37123("Server Id", () -> this.field_17601);
        }
        return this.method_3859($$0);
    }

    public abstract class_6396 method_3859(class_6396 var1);

    public class_6683 method_24307() {
        return class_6683.method_39031(field_34982, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void method_43496(class_2561 $$0) {
        field_4546.info($$0.getString());
    }

    public KeyPair method_3716() {
        return this.field_4552;
    }

    public int method_3756() {
        return this.field_4555;
    }

    public void method_3779(int $$0) {
        this.field_4555 = $$0;
    }

    @Nullable
    public GameProfile method_43824() {
        return this.field_39214;
    }

    public void method_43825(@Nullable GameProfile $$0) {
        this.field_39214 = $$0;
    }

    public boolean method_3724() {
        return this.field_39214 != null;
    }

    protected void method_31400() {
        field_4546.info("Generating keypair");
        try {
            this.field_4552 = class_3515.method_15237();
        }
        catch (class_5525 $$0) {
            throw new IllegalStateException("Failed to generate key pair", $$0);
        }
    }

    public void method_3776(class_1267 $$0, boolean $$1) {
        if (!$$1 && this.field_24372.method_197()) {
            return;
        }
        this.field_24372.method_208(this.field_24372.method_152() ? class_1267.field_5807 : $$0);
        this.method_27729();
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    public int method_27903(int $$0) {
        return $$0;
    }

    private void method_27729() {
        for (class_3218 $$0 : this.method_3738()) {
            $$0.method_8424(this.method_3783(), this.method_3796());
        }
    }

    public void method_19467(boolean $$0) {
        this.field_24372.method_186($$0);
        this.method_3760().method_14571().forEach(this::method_19465);
    }

    private void method_19465(class_3222 $$0) {
        class_5217 $$1 = $$0.method_14220().method_8401();
        $$0.field_13987.method_14364(new class_2632($$1.method_207(), $$1.method_197()));
    }

    public boolean method_3783() {
        return this.field_24372.method_207() != class_1267.field_5801;
    }

    public boolean method_3799() {
        return this.field_4549;
    }

    public void method_3730(boolean $$0) {
        this.field_4549 = $$0;
    }

    public Optional<class_7460> method_43659() {
        return Optional.empty();
    }

    public boolean method_32303() {
        return this.method_43659().filter(class_7460::comp_786).isPresent();
    }

    public abstract boolean method_3816();

    public abstract int method_30612();

    public boolean method_3828() {
        return this.field_4543;
    }

    public void method_3864(boolean $$0) {
        this.field_4543 = $$0;
    }

    public boolean method_3775() {
        return this.field_4560;
    }

    public void method_3764(boolean $$0) {
        this.field_4560 = $$0;
    }

    public boolean method_3796() {
        return true;
    }

    public boolean method_3736() {
        return true;
    }

    public abstract boolean method_3759();

    public boolean method_3852() {
        return this.field_4604;
    }

    public void method_3815(boolean $$0) {
        this.field_4604 = $$0;
    }

    public boolean method_3718() {
        return this.field_4554;
    }

    public void method_3745(boolean $$0) {
        this.field_4554 = $$0;
    }

    public abstract boolean method_3812();

    public String method_3818() {
        return this.field_4564;
    }

    public void method_3834(String $$0) {
        this.field_4564 = $$0;
    }

    public boolean method_3750() {
        return this.field_4561;
    }

    public class_3324 method_3760() {
        return this.field_4550;
    }

    public void method_3846(class_3324 $$0) {
        this.field_4550 = $$0;
    }

    public abstract boolean method_3860();

    public void method_3838(class_1934 $$0) {
        this.field_24372.method_193($$0);
    }

    @Nullable
    public class_3242 method_3787() {
        return this.field_4563;
    }

    public boolean method_3820() {
        return this.field_4547;
    }

    public boolean method_3727() {
        return false;
    }

    public boolean method_3763(@Nullable class_1934 $$0, boolean $$1, int $$2) {
        return false;
    }

    public int method_3780() {
        return this.field_4572;
    }

    public int method_3841() {
        return 16;
    }

    public boolean method_3785(class_3218 $$0, class_2338 $$1, class_1657 $$2) {
        return false;
    }

    public boolean method_27902() {
        return true;
    }

    public boolean method_39424() {
        return false;
    }

    public Proxy method_36113() {
        return this.field_4599;
    }

    public int method_3862() {
        return this.field_4596;
    }

    public void method_3803(int $$0) {
        this.field_4596 = $$0;
    }

    public MinecraftSessionService method_3844() {
        return this.field_39440.comp_837();
    }

    public class_7500 method_44301() {
        return this.field_39440.comp_838();
    }

    public GameProfileRepository method_3719() {
        return this.field_39440.comp_839();
    }

    public class_3312 method_3793() {
        return this.field_39440.comp_840();
    }

    @Nullable
    public class_2926 method_3765() {
        return this.field_4593;
    }

    public void method_3856() {
        this.field_4551 = 0L;
    }

    public int method_3749() {
        return 29999984;
    }

    @Override
    public boolean method_5384() {
        return super.method_5384() && !this.method_3750();
    }

    @Override
    public void method_40000(Runnable $$0) {
        if (this.method_3750()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.method_40000($$0);
    }

    @Override
    public Thread method_3777() {
        return this.field_16257;
    }

    public int method_3773() {
        return 256;
    }

    public boolean method_43500() {
        return false;
    }

    public long method_3826() {
        return this.field_4571;
    }

    public DataFixer method_3855() {
        return this.field_4587;
    }

    public int method_3829(@Nullable class_3218 $$0) {
        if ($$0 != null) {
            return $$0.method_8450().method_8356(class_1928.field_19403);
        }
        return 10;
    }

    public class_2989 method_3851() {
        return this.field_25318.comp_353.method_29473();
    }

    public class_2991 method_3740() {
        return this.field_4591;
    }

    public CompletableFuture<Void> method_29439(Collection<String> $$0) {
        class_5455.class_6890 $$13 = this.field_25132.method_45935(class_7659.field_39974);
        CompletionStage $$2 = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)$$0.stream().map(this.field_4595::method_14449).filter(Objects::nonNull).map(class_3288::method_14458).collect(ImmutableList.toImmutableList()), this).thenCompose($$12 -> {
            class_6861 $$22 = new class_6861(class_3264.field_14190, (List<class_3262>)$$12);
            return ((CompletableFuture)class_5350.method_29466($$22, $$13, this.field_24372.method_45560(), this.method_3816() ? class_2170.class_5364.field_25420 : class_2170.class_5364.field_25421, this.method_21714(), this.field_17200, this).whenComplete(($$1, $$2) -> {
                if ($$2 != null) {
                    $$22.close();
                }
            })).thenApply($$1 -> new class_6897($$22, (class_5350)$$1));
        })).thenAcceptAsync($$1 -> {
            this.field_25318.close();
            this.field_25318 = $$1;
            this.field_4595.method_14447($$0);
            class_7712 $$2 = new class_7712(MinecraftServer.method_29735(this.field_4595), this.field_24372.method_45560());
            this.field_24372.method_29590($$2);
            this.field_25318.comp_353.method_40421(this.method_30611());
            this.method_3760().method_14617();
            this.method_3760().method_14572();
            this.field_4591.method_29461(this.field_25318.comp_353.method_29465());
            this.field_24370.method_29300(this.field_25318.comp_352);
        }, (Executor)this);
        if (this.method_18854()) {
            this.method_18857(((CompletableFuture)$$2)::isDone);
        }
        return $$2;
    }

    public static class_7712 method_29736(class_3283 $$0, class_5359 $$1, boolean $$2, class_7699 $$3) {
        $$0.method_14445();
        if ($$2) {
            $$0.method_14447(Collections.singleton(field_34982));
            return class_7712.field_40260;
        }
        LinkedHashSet $$4 = Sets.newLinkedHashSet();
        for (String $$5 : $$1.method_29547()) {
            if ($$0.method_29207($$5)) {
                $$4.add($$5);
                continue;
            }
            field_4546.warn("Missing data pack {}", (Object)$$5);
        }
        for (class_3288 $$6 : $$0.method_14441()) {
            String $$7 = $$6.method_14463();
            if ($$1.method_29550().contains($$7)) continue;
            class_7699 $$8 = $$6.method_45276();
            boolean $$9 = $$4.contains($$7);
            if (!$$9 && $$6.method_29483().method_45279()) {
                if ($$8.method_45400($$3)) {
                    field_4546.info("Found new data pack {}, loading it automatically", (Object)$$7);
                    $$4.add($$7);
                } else {
                    field_4546.info("Found new data pack {}, but can't load it due to missing features {}", (Object)$$7, (Object)class_7701.method_45407($$3, $$8));
                }
            }
            if (!$$9 || $$8.method_45400($$3)) continue;
            field_4546.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)$$7, (Object)class_7701.method_45407($$3, $$8));
            $$4.remove($$7);
        }
        if ($$4.isEmpty()) {
            field_4546.info("No datapacks selected, forcing vanilla");
            $$4.add(field_34982);
        }
        $$0.method_14447($$4);
        class_5359 $$10 = MinecraftServer.method_29735($$0);
        class_7699 $$11 = $$0.method_45278();
        return new class_7712($$10, $$11);
    }

    private static class_5359 method_29735(class_3283 $$0) {
        Collection<String> $$12 = $$0.method_29210();
        ImmutableList $$2 = ImmutableList.copyOf($$12);
        List $$3 = (List)$$0.method_29206().stream().filter($$1 -> !$$12.contains($$1)).collect(ImmutableList.toImmutableList());
        return new class_5359((List<String>)$$2, $$3);
    }

    public void method_3728(class_2168 $$0) {
        if (!this.method_3729()) {
            return;
        }
        class_3324 $$1 = $$0.method_9211().method_3760();
        class_3337 $$2 = $$1.method_14590();
        ArrayList $$3 = Lists.newArrayList($$1.method_14571());
        for (class_3222 $$4 : $$3) {
            if ($$2.method_14653($$4.method_7334())) continue;
            $$4.field_13987.method_14367(class_2561.method_43471("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public class_3283 method_3836() {
        return this.field_4595;
    }

    public class_2170 method_3734() {
        return this.field_25318.comp_353.method_29472();
    }

    public class_2168 method_3739() {
        class_3218 $$0 = this.method_30002();
        return new class_2168(this, $$0 == null ? class_243.field_1353 : class_243.method_24954($$0.method_43126()), class_241.field_1340, $$0, 4, "Server", class_2561.method_43470("Server"), this, null);
    }

    @Override
    public boolean method_9200() {
        return true;
    }

    @Override
    public boolean method_9202() {
        return true;
    }

    @Override
    public abstract boolean method_9201();

    public class_1863 method_3772() {
        return this.field_25318.comp_353.method_29471();
    }

    public class_2995 method_3845() {
        return this.field_4558;
    }

    public class_4565 method_22827() {
        if (this.field_20850 == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.field_20850;
    }

    public class_60 method_3857() {
        return this.field_25318.comp_353.method_29469();
    }

    public class_4567 method_22828() {
        return this.field_25318.comp_353.method_29468();
    }

    public class_5640 method_32699() {
        return this.field_25318.comp_353.method_32703();
    }

    public class_1928 method_3767() {
        return this.method_30002().method_8450();
    }

    public class_3004 method_3837() {
        return this.field_4548;
    }

    public boolean method_3729() {
        return this.field_4570;
    }

    public void method_3731(boolean $$0) {
        this.field_4570 = $$0;
    }

    public float method_3830() {
        return this.field_4592;
    }

    public int method_3835(GameProfile $$0) {
        if (this.method_3760().method_14569($$0)) {
            class_3327 $$1 = (class_3327)this.method_3760().method_14603().method_14640($$0);
            if ($$1 != null) {
                return $$1.method_14623();
            }
            if (this.method_19466($$0)) {
                return 4;
            }
            if (this.method_3724()) {
                return this.method_3760().method_14579() ? 4 : 0;
            }
            return this.method_3798();
        }
        return 0;
    }

    public class_3517 method_15876() {
        return this.field_16205;
    }

    public class_3695 method_16044() {
        return this.field_16258;
    }

    public abstract boolean method_19466(GameProfile var1);

    public void method_37113(Path $$0) throws IOException {
    }

    private void method_21613(Path $$0) {
        Path $$1 = $$0.resolve("levels");
        try {
            for (Map.Entry<class_5321<class_1937>, class_3218> $$2 : this.field_4589.entrySet()) {
                class_2960 $$3 = $$2.getKey().method_29177();
                Path $$4 = $$1.resolve($$3.method_12836()).resolve($$3.method_12832());
                Files.createDirectories($$4, new FileAttribute[0]);
                $$2.getValue().method_21625($$4);
            }
            this.method_21615($$0.resolve("gamerules.txt"));
            this.method_21616($$0.resolve("classpath.txt"));
            this.method_21692($$0.resolve("stats.txt"));
            this.method_21713($$0.resolve("threads.txt"));
            this.method_37113($$0.resolve("server.properties.txt"));
            this.method_38584($$0.resolve("modules.txt"));
        }
        catch (IOException $$5) {
            field_4546.warn("Failed to save debug report", (Throwable)$$5);
        }
    }

    private void method_21692(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            $$1.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.method_21684()));
            $$1.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.method_3830())));
            $$1.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.field_4573)));
            $$1.write(String.format(Locale.ROOT, "queue: %s\n", class_156.method_18349()));
        }
    }

    private void method_21615(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            final ArrayList $$2 = Lists.newArrayList();
            final class_1928 $$3 = this.method_3767();
            class_1928.method_20744(new class_1928.class_4311(){

                @Override
                public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> $$0, class_1928.class_4314<T> $$1) {
                    $$2.add(String.format(Locale.ROOT, "%s=%s\n", $$0.method_20771(), $$3.method_20746($$0)));
                }
            });
            for (String $$4 : $$2) {
                $$1.write($$4);
            }
        }
    }

    private void method_21616(Path $$0) throws IOException {
        try (BufferedWriter $$1 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            String $$2 = System.getProperty("java.class.path");
            String $$3 = System.getProperty("path.separator");
            for (String $$4 : Splitter.on((String)$$3).split((CharSequence)$$2)) {
                $$1.write($$4);
                $$1.write("\n");
            }
        }
    }

    private void method_21713(Path $$0) throws IOException {
        ThreadMXBean $$1 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] $$2 = $$1.dumpAllThreads(true, true);
        Arrays.sort($$2, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter $$3 = Files.newBufferedWriter($$0, new OpenOption[0]);){
            for (ThreadInfo $$4 : $$2) {
                $$3.write($$4.toString());
                ((Writer)$$3).write(10);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void method_38584(Path $$02) throws IOException {
        BufferedWriter $$1 = Files.newBufferedWriter($$02, new OpenOption[0]);
        try {
            void $$4;
            try {
                ArrayList $$2 = Lists.newArrayList(class_6498.method_37961());
            }
            catch (Throwable $$3) {
                field_4546.warn("Failed to list native modules", $$3);
                if ($$1 != null) {
                    ((Writer)$$1).close();
                }
                return;
            }
            $$4.sort(Comparator.comparing($$0 -> $$0.field_34396));
            for (class_6498.class_6499 $$5 : $$4) {
                $$1.write($$5.toString());
                ((Writer)$$1).write(10);
            }
        }
        finally {
            if ($$1 != null) {
                try {
                    ((Writer)$$1).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void method_24487() {
        if (this.field_33977) {
            this.field_22250 = class_5961.method_37191(new class_6402(class_156.field_1128, this.method_3816()), class_156.field_1128, class_156.method_27958(), new class_5971("server"), this.field_33975, $$0 -> {
                this.method_19537(() -> this.method_21613($$0.resolve("server")));
                this.field_33976.accept((Path)$$0);
            });
            this.field_33977 = false;
        }
        this.field_16258 = class_4758.method_24340(this.field_22250.method_34774(), class_4758.method_24341("Server"));
        this.field_22250.method_34771();
        this.field_16258.method_16065();
    }

    private void method_24490() {
        this.field_16258.method_16066();
        this.field_22250.method_34772();
    }

    public boolean method_37321() {
        return this.field_22250.method_34773();
    }

    public void method_37320(Consumer<class_3696> $$0, Consumer<Path> $$12) {
        this.field_33975 = $$1 -> {
            this.method_37322();
            $$0.accept((class_3696)$$1);
        };
        this.field_33976 = $$12;
        this.field_33977 = true;
    }

    public void method_37322() {
        this.field_22250 = class_5963.field_29594;
    }

    public void method_37323() {
        this.field_22250.method_34770();
    }

    public void method_42062() {
        this.field_22250.method_41320();
        this.field_16258 = this.field_22250.method_34774();
    }

    public Path method_27050(class_5218 $$0) {
        return this.field_23784.method_27010($$0);
    }

    public boolean method_27051() {
        return true;
    }

    public class_3485 method_27727() {
        return this.field_24370;
    }

    public class_5219 method_27728() {
        return this.field_24372;
    }

    public class_5455.class_6890 method_30611() {
        return this.field_25132.method_45926();
    }

    public class_7780<class_7659> method_46221() {
        return this.field_25132;
    }

    public class_5513 method_31371(class_3222 $$0) {
        return class_5513.field_28862;
    }

    public class_3225 method_32816(class_3222 $$0) {
        return this.method_3799() ? new class_3201($$0) : new class_3225($$0);
    }

    @Nullable
    public class_1934 method_3761() {
        return null;
    }

    public class_3300 method_34864() {
        return this.field_25318.comp_352;
    }

    public boolean method_39219() {
        return this.field_35437;
    }

    public boolean method_24488() {
        return this.field_33979 || this.field_33978 != null;
    }

    public void method_3832() {
        this.field_33979 = true;
    }

    public class_3696 method_24489() {
        if (this.field_33978 == null) {
            return class_3688.field_16265;
        }
        class_3696 $$0 = this.field_33978.method_37330(class_156.method_648(), this.field_4572);
        this.field_33978 = null;
        return $$0;
    }

    public int method_41239() {
        return 1000000;
    }

    public void method_43614(class_2561 $$0, class_2556.class_7602 $$1, @Nullable String $$2) {
        String $$3 = $$1.method_44837($$0).getString();
        if ($$2 != null) {
            field_4546.info("[{}] {}", (Object)$$2, (Object)$$3);
        } else {
            field_4546.info("{}", (Object)$$3);
        }
    }

    public class_7492 method_43929() {
        return class_7492.field_39384;
    }

    @Override
    public /* synthetic */ void method_18859(Runnable runnable) {
        this.method_24306((class_3738)runnable);
    }

    @Override
    public /* synthetic */ boolean method_18856(Runnable runnable) {
        return this.method_19464((class_3738)runnable);
    }

    @Override
    public /* synthetic */ Runnable method_16211(Runnable runnable) {
        return this.method_16209(runnable);
    }

    static final class class_6897
    extends Record
    implements AutoCloseable {
        final class_6860 comp_352;
        final class_5350 comp_353;

        class_6897(class_6860 $$0, class_5350 $$1) {
            this.comp_352 = $$0;
            this.comp_353 = $$1;
        }

        @Override
        public void close() {
            this.comp_352.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{class_6897.class, "resourceManager;managers", "comp_352", "comp_353"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{class_6897.class, "resourceManager;managers", "comp_352", "comp_353"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{class_6897.class, "resourceManager;managers", "comp_352", "comp_353"}, this, $$0);
        }

        public class_6860 comp_352() {
            return this.comp_352;
        }

        public class_5350 comp_353() {
            return this.comp_353;
        }
    }

    static class class_6414 {
        final long field_33980;
        final int field_33981;

        class_6414(long $$0, int $$1) {
            this.field_33980 = $$0;
            this.field_33981 = $$1;
        }

        class_3696 method_37330(final long $$0, final int $$1) {
            return new class_3696(){

                @Override
                public List<class_3534> method_16067(String $$02) {
                    return Collections.emptyList();
                }

                @Override
                public boolean method_16069(Path $$02) {
                    return false;
                }

                @Override
                public long method_16068() {
                    return field_33980;
                }

                @Override
                public int method_16072() {
                    return field_33981;
                }

                @Override
                public long method_16073() {
                    return $$0;
                }

                @Override
                public int method_16070() {
                    return $$1;
                }

                @Override
                public String method_34970() {
                    return "";
                }
            };
        }
    }

    public record class_7460(String comp_784, String comp_785, boolean comp_786, @Nullable class_2561 comp_787) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{class_7460.class, "url;hash;isRequired;prompt", "comp_784", "comp_785", "comp_786", "comp_787"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{class_7460.class, "url;hash;isRequired;prompt", "comp_784", "comp_785", "comp_786", "comp_787"}, this);
        }

        @Override
        public final boolean equals(Object $$0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{class_7460.class, "url;hash;isRequired;prompt", "comp_784", "comp_785", "comp_786", "comp_787"}, this, $$0);
        }
    }
}

